﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;
    using Hims.Api.Models;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The scan log controller.
    /// </summary>
    [Route("api/scan-log")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class ScanLogController : BaseController
    {
        /// <summary>
        /// The pharmacy log service.
        /// </summary>
        private readonly IScanLogService scanLogService;

        /// <inheritdoc />
        public ScanLogController(IScanLogService scanLogService) => this.scanLogService = scanLogService;



        /// <summary>
        /// To fetch scan logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of scan logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of scanLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>

        [HttpPost]
        [Authorize]
        [Route("fetch-scan-logs")]
        [ProducesResponseType(typeof(IEnumerable<ScanLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> FetchAsync([FromBody] ScanLogFilterModel model, [FromHeader] LocationHeader header)
        {
            model = (ScanLogFilterModel)EmptyFilter.Handler(model);
            model.LocationId = Convert.ToInt32(header.LocationId);
            var scanLogs = await scanLogService.FetchAsync(model);
            if (scanLogs == null)
            {
                return ServerError();
            }
            return Success(scanLogs);
        }

        /// <summary>
        /// To insert scan logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of scan logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of scan Logs.
        /// - 500 - Problem with Server side code.
        /// </remarks>

        [HttpPost]
        [Authorize]
        [Route("insert-scan-logs")]
        [ProducesResponseType(500)]
        public async Task<int> InsertAsync([FromBody] ScanLogModel model, [FromHeader] LocationHeader header)
        {
            model = (ScanLogModel)EmptyFilter.Handler(model);
            model.LogDate = DateTime.UtcNow;
            model.LocationId = Convert.ToInt32(header.LocationId);
            await scanLogService.LogAsync(model);
            return 1;
        }
    }
}
